/**
 * External dependencies
 */
import styled from '@emotion/styled';

/**
 * Internal dependencies
 */
import { Logo } from '@ithemes/security-ui';

export const StyledSiteTypeChooser = styled.div`
	display: flex;
	flex-direction: column;
	gap: 1.25rem;
	max-width: 670px;
`;

export const StyledLogo = styled( Logo )`
	height: 44px;
	width: auto;
	align-self: start;
`;

export const StyledHeader = styled.header`
	display: flex;
	flex-direction: column;
	gap: 0.5rem;
`;

export const brochure = (
	<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
		<path d="M9 4C8.44531 4 8 4.44531 8 5V6H3C2.44531 6 2 6.44531 2 7V23C2 23.5547 2.44531 24 3 24H8V25C8 25.5547 8.44531 26 9 26H23C23.5547 26 24 25.5547 24 25V24H29C29.5547 24 30 23.5547 30 23V7C30 6.44531 29.5547 6 29 6H24V5C24 4.44531 23.5547 4 23 4H9ZM10 6H22V24H10V6ZM4 8H8V22H4V8ZM12 8V10H20V8H12ZM24 8H28V22H24V8ZM12 12V14H20V12H12ZM12 16V18H20V16H12ZM12 20V22H20V20H12Z" fill="#9675F7" />
	</svg>
);

export const blog = (
	<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
		<g clipPath="url(#clip0_5527_131266)">
			<path d="M8.94922 4C7.30416 4 5.94922 5.35494 5.94922 7V25C5.94922 26.6451 7.30416 28 8.94922 28H14V26H8.94922C8.38628 26 7.94922 25.5629 7.94922 25V7C7.94922 6.43706 8.38628 6 8.94922 6H17.9492V12H23.9492V14H25.9492V10.5859L19.3633 4H8.94922ZM19.9492 7.41406L22.5352 10H19.9492V7.41406ZM28.3633 16.0078C27.7056 16.012 27.0494 16.2678 26.5586 16.7695L17.3125 26.1758L15.9023 32.1016L21.8242 30.6914L22.0234 30.4961L31.2344 21.4492C32.2423 20.4642 32.2502 18.8167 31.2539 17.8203L30.1836 16.75C29.685 16.2514 29.0239 16.0036 28.3633 16.0078ZM28.375 17.9961C28.5143 17.9952 28.6561 18.0506 28.7695 18.1641L29.8398 19.2344C30.0634 19.458 30.0641 19.7966 29.8359 20.0195V20.0234L20.8242 28.8711L18.6016 29.4023L19.1289 27.1836L27.9844 18.1719L27.9883 18.168C28.0988 18.0542 28.2357 17.997 28.375 17.9961Z" fill="#9675F7" />
		</g>
		<defs>
			<clipPath id="clip0_5527_131266">
				<rect width="32" height="32" fill="white" />
			</clipPath>
		</defs>
	</svg>
);

export const network = (
	<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
		<path d="M8 0C6.90625 0 6 0.90625 6 2V11C6 11.5547 6.44531 12 7 12H23C23.5547 12 24 11.5547 24 11V2C24 0.90625 23.0938 0 22 0H8ZM8 4H22V10H8V4ZM8.46875 14L4.86719 20H7.20313L10.7969 14H8.46875ZM14 14V20H16V14H14ZM19.2031 14L22.8047 20H25.1328L21.5312 14H19.2031ZM2 22C0.898438 22 0 22.8984 0 24V28C0 29.1016 0.898438 30 2 30H6C7.10156 30 8 29.1016 8 28V24C8 22.8984 7.10156 22 6 22H2ZM12 22C10.8984 22 10 22.8984 10 24V28C10 29.1016 10.8984 30 12 30H18C19.1016 30 20 29.1016 20 28V24C20 22.8984 19.1016 22 18 22H12ZM24 22C22.8984 22 22 22.8984 22 24V28C22 29.1016 22.8984 30 24 30H28C29.1016 30 30 29.1016 30 28V24C30 22.8984 29.1016 22 28 22H24ZM2 24H6V28H2V24ZM12 24H18V28H12V24ZM24 24H28V28H24V24Z" fill="#9675F7" />
	</svg>
);

export const portfolio = (
	<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
		<path d="M13 2C11.3549 2 10 3.35494 10 5V6H5C3.35494 6 2 7.35494 2 9V25C2 26.6451 3.35494 28 5 28H27C28.6451 28 30 26.6451 30 25V9C30 7.35494 28.6451 6 27 6H22V5C22 3.35494 20.6451 2 19 2H13ZM13 4H19C19.5629 4 20 4.43706 20 5V6H12V5C12 4.43706 12.4371 4 13 4ZM5 8H27C27.5629 8 28 8.43706 28 9V25C28 25.5629 27.5629 26 27 26H5C4.43706 26 4 25.5629 4 25V9C4 8.43706 4.43706 8 5 8ZM16 10C14.75 10 13.6872 10.5048 13.0039 11.2734C12.3206 12.0421 12 13.0278 12 14C12 14.9722 12.3206 15.9579 13.0039 16.7266C13.1446 16.8849 13.4498 16.8545 13.6211 16.9883C11.6082 17.9589 10 19.6245 10 22H12C12 19.7782 13.7782 18 16 18C18.2218 18 20 19.7782 20 22H22C22 19.6245 20.3918 17.9589 18.3789 16.9883C18.5502 16.8545 18.8554 16.8849 18.9961 16.7266C19.6794 15.9579 20 14.9722 20 14C20 13.0278 19.6794 12.0421 18.9961 11.2734C18.3128 10.5048 17.25 10 16 10ZM16 12C16.75 12 17.1872 12.2452 17.5039 12.6016C17.8206 12.9579 18 13.4722 18 14C18 14.5278 17.8206 15.0421 17.5039 15.3984C17.1872 15.7548 16.75 16 16 16C15.25 16 14.8128 15.7548 14.4961 15.3984C14.1794 15.0421 14 14.5278 14 14C14 13.4722 14.1794 12.9579 14.4961 12.6016C14.8128 12.2452 15.25 12 16 12Z" fill="#9675F7" />
	</svg>
);

export const ecommerce = (
	<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
		<path d="M16.0016 2C12.7047 2 10.0016 4.70313 10.0016 8H6.00157C5.47032 8 5.03282 8.41406 5.00157 8.94531L4.00157 26.9453C3.98595 27.2188 4.08751 27.4922 4.27501 27.6875C4.46251 27.8906 4.72813 28 5.00157 28H27.0016C27.275 28 27.5406 27.8906 27.7281 27.6875C27.9156 27.4922 28.0172 27.2188 28.0016 26.9453L27.0016 8.94531C26.9703 8.41406 26.5328 8 26.0016 8H22.0016C22.0016 4.70313 19.2984 2 16.0016 2ZM16.0016 4C18.2047 4 20.0016 5.79688 20.0016 8H12.0016C12.0016 5.79688 13.7984 4 16.0016 4ZM6.94688 10H10.0016V14H12.0016V10H20.0016V14H22.0016V10H25.0563L25.9391 26H6.06407L6.94688 10Z" fill="#9675F7" />
	</svg>
);

export const nonProfit = (
	<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
		<path d="M17 2C15.625 2 14.4688 2.95313 14.1172 4.21875C13.7734 4.07813 13.3906 4 13 4C11.3516 4 10 5.35156 10 7V17L7.89063 16.1406L7.84375 16.125C6.25781 15.6641 4.57813 16.5781 4.125 18.1562C4.03906 18.4375 4 18.7188 4 19C4 20.2578 4.80469 21.3047 5.89063 22.0078L5.8125 21.9531L10.125 25.3984C11.7656 26.8047 13.6641 28 16 28H20C24.375 28 28 24.4297 28 20.0391V9C28 7.35156 26.6484 6 25 6C24.6484 6 24.3125 6.07813 24 6.1875V6C24 4.35156 22.6484 3 21 3C20.4297 3 19.8984 3.17188 19.4453 3.45313C19.0234 2.89844 18.4062 2.47656 17.6875 2.28125C17.5 2.10938 17.2578 2.00781 17 2ZM17 4C17.5625 4 18 4.4375 18 5V14H20V6C20 5.4375 20.4375 5 21 5C21.5625 5 22 5.4375 22 6V14H24V9C24 8.4375 24.4375 8 25 8C25.5625 8 26 8.4375 26 9V20.0391C26 23.3281 23.2969 26 20 26H16C14.3438 26 12.9219 25.1562 11.4375 23.875L11.4219 23.8672L7.03125 20.3594L6.98438 20.3359C6.20313 19.8281 6 19.4766 6 19C6 18.9141 6.01563 18.8125 6.03906 18.7188C6.19531 18.1797 6.73438 17.8906 7.27344 18.0469L12 20V7C12 6.4375 12.4375 6 13 6C13.5625 6 14 6.4375 14 7V14H16V5C16 4.4375 16.4375 4 17 4ZM17.25 16C16.3516 16 16 16.7266 16 17.625C16 19.4531 19 22 19 22C19 22 22 19.5 22 17.625C22 16.7266 21.6484 16 20.75 16C19.5547 16 19 17.3672 19 18C19 17.3672 18.4219 16 17.25 16Z" fill="#9675F7" />
	</svg>
);
